/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;
import xaero.common.MinimapLogs;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.misc.Misc;

public class EntityIconModelPartsRenderer {
    private Field cubeListField = Misc.getFieldReflection(ModelRenderer.class, "field_78804_l", "cubeList");
    private Field childModelsField = Misc.getFieldReflection(ModelRenderer.class, "field_78805_m", "childModels");

    private List<ModelBox> getCubeList(ModelRenderer modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, this.cubeListField);
    }

    private List<ModelRenderer> getChildModels(ModelRenderer modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, this.childModelsField);
    }

    public boolean hasDirectCubes(ModelRenderer mr) {
        List<ModelBox> mrCubeList = this.getCubeList(mr);
        return mrCubeList != null && !mrCubeList.isEmpty();
    }

    public boolean hasCubes(ModelRenderer mr) {
        if (this.hasDirectCubes(mr)) {
            return true;
        }
        List<ModelRenderer> mrChildren = this.getChildModels(mr);
        if (mrChildren != null) {
            for (ModelRenderer child : mrChildren) {
                if (!this.hasCubes(child)) continue;
                return true;
            }
        }
        return false;
    }

    public void renderPart(ModelRenderer mr, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        float rotationPointBUX = mr.field_78800_c;
        float rotationPointBUY = mr.field_78797_d;
        float rotationPointBUZ = mr.field_78798_e;
        float rotateAngleBUX = mr.field_78795_f;
        float rotateAngleBUY = mr.field_78796_g;
        float rotateAngleBUZ = mr.field_78808_h;
        boolean showModelBU = mr.field_78806_j;
        boolean isHiddenBU = mr.field_78807_k;
        float centerPointX = mainModelPart.field_78800_c;
        float centerPointY = mainModelPart.field_78797_d;
        float centerPointZ = mainModelPart.field_78798_e;
        List<ModelBox> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            float biggestSize = 0.0f;
            ModelBox biggestCuboid = null;
            for (ModelBox cuboid : mainCubeList) {
                float size = Math.abs((cuboid.field_78248_d - cuboid.field_78252_a) * (cuboid.field_78249_e - cuboid.field_78250_b) * (cuboid.field_78246_f - cuboid.field_78251_c));
                if (!(size >= biggestSize)) continue;
                biggestCuboid = cuboid;
                biggestSize = size;
            }
            centerPointY += (biggestCuboid.field_78249_e + biggestCuboid.field_78250_b) / 2.0f;
            centerPointZ += (biggestCuboid.field_78246_f + biggestCuboid.field_78251_c) / 2.0f;
        }
        if (zeroRotation) {
            mr.field_78795_f = 0.0f;
            mr.field_78796_g = 0.0f;
            mr.field_78808_h = 0.0f;
        }
        mr.field_78806_j = true;
        mr.field_78807_k = false;
        GlStateManager.func_179131_c((float)renderInfo.red, (float)renderInfo.green, (float)renderInfo.blue, (float)renderInfo.alpha);
        try {
            mr.func_78793_a(mr.field_78800_c - centerPointX, mr.field_78797_d - centerPointY, mr.field_78798_e - centerPointZ);
            mr.func_78785_a(0.0625f);
            renderedModels.add(mr);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + mr);
        }
        while (GL11.glGetError() != 0) {
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mr.field_78800_c = rotationPointBUX;
        mr.field_78797_d = rotationPointBUY;
        mr.field_78798_e = rotationPointBUZ;
        if (zeroRotation) {
            mr.field_78795_f = rotateAngleBUX;
            mr.field_78796_g = rotateAngleBUY;
            mr.field_78808_h = rotateAngleBUZ;
        }
        mr.field_78806_j = showModelBU;
        mr.field_78807_k = isHiddenBU;
    }

    public ModelRenderer renderDeclaredMethod(Method m, ModelBase entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<ModelRenderer> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, renderedModels, mainPart, zeroRotation, mrde);
    }

    public Iterable<ModelRenderer> handleDeclaredMethod(Method m, ModelBase entityModel) {
        if (m != null) {
            return (Iterable)Misc.getReflectMethodValue(entityModel, m, new Object[0]);
        }
        return null;
    }

    public ModelRenderer renderPartsIterable(Iterable<ModelRenderer> parts, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelRenderer> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }
}

